package java.lang;

/* Class Throwable is the superclass of all errors and exceptions in
   Java. Only objects that are instances of this class (or of one of
   its subclasses) are thrown by the Java Virtual Machine or can be
   thrown by the Java throw statement. Similarly, only this class or
   one of its subclasses can be the parameter type in a catch clause. 

   A Throwable object contains the call stack of its thread at the
   time the object was created. It can also contain a "detail message"
   that gives more information about the error. 
   */
public class Throwable implements java.io.Serializable {
    /** Native code saves an indication of the call stack here */
    private transient Object backtrace;	

    /** Contains specific details about this Throwable, e.g. for 
       FileNotFoundThrowables, contains the name of the file that
       could not be found.
       */
    private String detailMessage;

    /** use serialVersionUID from JDK 1.0.2 for interoperability */
    private static final long serialVersionUID = -3042686055658047285L;

    /** Constructor: an instance with no detail message and a call stack */
    public Throwable() {
	    fillInStackTrace();
    }

    /** Constructor: an instance with message m and a call stack */
    public Throwable(String m) {
	    fillInStackTrace();
	    detailMessage = message;
    }

    /** = the detail message of this throwable object (null if none) */
    public String getMessage() {
       return detailMessage;
    }

    /** = localized description of this instance. If not overridden
          it's the same result as getMessage(). */
    public String getLocalizedMessage() {
       return getMessage();
    }

    /** = a short description of this instance */
    public String toString() {
	    String s = getClass().getName();
	    String message = getMessage();
	    return (message != null) ? (s + ": " + message) : s;
    }

    /** Print this instance and its call stack */
    public void printStackTrace() { 
       System.err.println(this);
       printStackTrace0(System.err);
    }

    /** Print this instance and its call stack on s */
    public void printStackTrace(java.io.PrintStream s) { 
       s.println(this);
	    printStackTrace0(s);
    }

    /** Print this instance and its call stack on s */
    public void printStackTrace(java.io.PrintWriter s) { 
       s.println(this);
	    printStackTrace0(s);
    }

    /** The instance must have method void println(char[]) */
    private native void printStackTrace0(Object s);

       /* Fill in the call stack. This method is useful when an 
       application is re-throwing an error or exception. E.g. 

          try {
              a = b / c;
          } catch(ArithmeticThrowable e) {
              a = Number.MAX_VALUE;
              throw e.fillInStackTrace();
          }
       */
    public native Throwable fillInStackTrace();

}
